// WordDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Word.h"
#include "WordDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CWordDlg dialog




CWordDlg::CWordDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWordDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	CoInitializeEx(NULL, 0);
	AfxInitRichEdit2();
}

void CWordDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT1, Edit1);
    DDX_Control(pDX, IDC_RICHEDIT21, RichEdit1);
}

BEGIN_MESSAGE_MAP(CWordDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
    ON_BN_CLICKED(IDC_BUTTON1, &CWordDlg::OnBnClickedButton1)
    ON_BN_CLICKED(IDC_BUTTON2, &CWordDlg::OnBnClickedButton2)
    ON_BN_CLICKED(IDC_BUTTON3, &CWordDlg::OnBnClickedButton3)
    ON_BN_CLICKED(IDC_BUTTON4, &CWordDlg::OnBnClickedButton4)
    ON_BN_CLICKED(IDC_BUTTON5, &CWordDlg::OnBnClickedButton5)
    ON_BN_CLICKED(IDC_BUTTON6, &CWordDlg::OnBnClickedButton6)
    ON_BN_CLICKED(IDC_BUTTON7, &CWordDlg::OnBnClickedButton7)
    ON_BN_CLICKED(IDC_BUTTON8, &CWordDlg::OnBnClickedButton8)
END_MESSAGE_MAP()


// CWordDlg message handlers

BOOL CWordDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWordDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWordDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

LPDISPATCH CWordDlg::GetIDispatch(CString AppName)
{
    CLSID clsid;
    CLSIDFromProgID(AppName, &clsid);
    IDispatch *pDisp;
    IUnknown *pUnk;
    
    HRESULT hr = GetActiveObject(clsid, NULL, (IUnknown**)&pUnk);
    ASSERT(!FAILED(hr));
        
    hr = pUnk->QueryInterface(IID_IDispatch, (void **)&pDisp);
    ASSERT(!FAILED(hr));

    // Zwolnienie niepotrzebnego ju interfejsu IUnknown
    pUnk->Release();
    return pDisp;
}


void CWordDlg::OnBnClickedButton1()
{
    COleVariant cOpt(DISP_E_PARAMNOTFOUND,VT_ERROR); //Parametr opcjonalny
    CDocument0 oDoc;
    CDocuments oDocs;
    
    oWord.CreateDispatch(L"Word.Application");
    oWord.put_Visible(TRUE);
    
    oDocs = oWord.get_Documents();
    oDoc = oDocs.Add(cOpt, cOpt, cOpt, cOpt);  
}

void CWordDlg::OnBnClickedButton2()
{
    COleVariant cOpt(DISP_E_PARAMNOTFOUND,VT_ERROR); //Parametr opcjonalny
    CDocument0 oDoc;
    CDocuments oDocs;
     
    oWord.CreateDispatch(L"Word.Application");   
    oWord.put_Visible(TRUE);
    
    CFileDialog fileDialog(TRUE, 0, 0, 2, 
            L"Dokumenty Word(*.doc)|*.doc|Wszystkie pliki (*.*)|*.*||");    
    
    if(fileDialog.DoModal() != IDCANCEL)
    {
        CString nazwaPliku = fileDialog.GetPathName();
        oDocs = oWord.get_Documents();
        oDoc = oDocs.Open(COleVariant(nazwaPliku), cOpt, cOpt, cOpt, cOpt, cOpt,
            cOpt, cOpt, cOpt, cOpt, cOpt, cOpt, cOpt, cOpt, cOpt, cOpt); 
    }
    else
        MessageBox(L"Anulowano otwarcie pliku");
}

void CWordDlg::OnBnClickedButton3()
{
    COleVariant cOpt(DISP_E_PARAMNOTFOUND,VT_ERROR); //Parametr opcjonalny
    CDocument0 oDoc;
    LPDISPATCH pDisp;
     
    pDisp = GetIDispatch(L"Word.Application");
    oWord.AttachDispatch(pDisp);  
    
    oWord.put_Visible(TRUE);
    oDoc = oWord.get_ActiveDocument();
    oDoc.CheckSpelling(cOpt, cOpt, cOpt, cOpt, cOpt, cOpt, cOpt, cOpt,
        cOpt, cOpt, cOpt, cOpt);
    //oDoc.PrintPreview(); //podgld wydruku
    //oDoc.PrintOut(cOpt, cOpt, cOpt, cOpt, cOpt, cOpt, cOpt, cOpt, cOpt, cOpt, cOpt, 
    //    cOpt, cOpt, cOpt, cOpt, cOpt, cOpt, cOpt); //drukowanie      
    
    oWord.ReleaseDispatch();
}

void CWordDlg::OnBnClickedButton4()
{
    LPDISPATCH pDisp;
    CSelection zakres;
    CString nowyTekst;
     
    pDisp = GetIDispatch(L"Word.Application");
    oWord.AttachDispatch(pDisp);  
    
    zakres = oWord.get_Selection();
    Edit1.GetWindowTextW(nowyTekst);
    zakres.put_Text(nowyTekst);
    zakres.Select();

    oWord.ReleaseDispatch();
}

void CWordDlg::OnBnClickedButton5()
{
    LPDISPATCH pDisp;
    CDocument0 oDoc;
    CString nowyTekst;
     
    pDisp = GetIDispatch(L"Word.Application");
    oWord.AttachDispatch(pDisp);  
    oDoc = oWord.get_ActiveDocument();
    oDoc.Save();
    
    oWord.ReleaseDispatch();
}

void CWordDlg::OnBnClickedButton6()
{
    LPDISPATCH pDisp;
    CDocument0 oDoc;
    CRange zakres;
    COleVariant cOpt(DISP_E_PARAMNOTFOUND,VT_ERROR);
     
    pDisp = GetIDispatch(L"Word.Application");
    oWord.AttachDispatch(pDisp);
    oDoc = oWord.get_ActiveDocument();
    zakres = oDoc.Range(cOpt, cOpt);
    zakres.Select();
    zakres.Copy();
    oWord.ReleaseDispatch();
}

void CWordDlg::OnBnClickedButton7()
{
    LPDISPATCH pDisp;
    CDocument0 oDoc;
    CRange zakres;
    CString tekst;
    COleVariant cOpt(DISP_E_PARAMNOTFOUND,VT_ERROR);
    
    pDisp = GetIDispatch(L"Word.Application");
    oWord.AttachDispatch(pDisp);
    oDoc = oWord.get_ActiveDocument();
    zakres = oDoc.Range(cOpt, cOpt);
    tekst = zakres.get_Text();
    
    RichEdit1.SetWindowTextW(tekst);    
    oWord.ReleaseDispatch();
}

void CWordDlg::OnBnClickedButton8()
{
    LPDISPATCH pDisp;
    CSelection zakres;
    CFont0 font;
    CFontDialog fontDialog;
     
    pDisp = GetIDispatch(L"Word.Application");
    oWord.AttachDispatch(pDisp);
        
    if(fontDialog.DoModal() != IDCANCEL)
    {
        zakres = oWord.get_Selection();
        font = zakres.get_Font();
        
        font.put_Bold(fontDialog.IsBold());
        font.put_Italic(fontDialog.IsItalic());
        font.put_Underline(fontDialog.IsUnderline());
        font.put_Color(fontDialog.GetColor());
        font.put_Size(fontDialog.GetSize()/10);
        font.put_Name(fontDialog.GetFaceName());    
    }
    oWord.ReleaseDispatch();
}
